#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

from AddOnePatient import AddOnePatient, gotoRegisterPatientMenu
from OSEHRAHelper import PROMPT
from ConnectToVista import ConnectToVista
import json
import sys

#---------------------------------------------------------------------
#- SECTION TO CREATE PATIENTS -
#---------------------------------------------------------------------

#
#  We expect to start here just after calling CreateSystemManager
#  and to be in the "Select Systems Manager Menu Option:"
#
def AddTestCommonPatients(VistA):
    AddOnePatient(VistA, 'ZZTEST', 'ONE', 'M', '11/01/1962', '100000000', 'Y')
    AddOnePatient(VistA, 'ZZTEST', 'TWO', 'F', '10/01/1963', '100000001', 'N')
    AddOnePatient(VistA, 'ZZTEST', 'THREE', 'M', '11/01/1964', '100000002', 'Y')
    AddOnePatient(VistA, 'ZZTEST', 'FOUR', 'F', '10/01/1965', '100000003', 'N')

PatientTestTuple = ('FIVE','SIX','SEVEN','EIGHT','NINE','TEN',
                    'ELEVEN','TWELVE','THIRTEEN','FOURTEEN')

def AddTestPatientBySite(VistA, siteName):
    isLastOne = False
    for index in range(0,len(PatientTestTuple)):
        isLastOne = (index == len(PatientTestTuple)-1)
        birthDate = '%02d/%02d/%4d' % (01,index+1,1966+index) # this is the birth date
        SSN = "%09d" % (000000004 + index) # this is the social security number
        if index % 2 == 0:
            AddOnePatient(VistA, 'ZZTEST', siteName + PatientTestTuple[index],
                          'M', birthDate, SSN, 'Y', isLastOne)
        else:
            AddOnePatient(VistA, 'ZZTEST', siteName + PatientTestTuple[index],
                          'F', birthDate, SSN, 'N', isLastOne)

TestPatientSet = set(["ALABAMA","GEORGIA"])

def AddTestPatients(VistA, siteName):
    AddTestCommonPatients(VistA)
    if siteName not in TestPatientSet:
        return
    AddTestPatientBySite(VistA, siteName)

def AddTestPatientsByConfig(VistA, patientsJson):
    gotoRegisterPatientMenu(VistA)
    for patient in patientsJson:
        isLastItem = (patient == patientsJson[-1])
        print patient
        AddOnePatient(VistA, patient.get('Last Name',''),
                      patient.get('First Name', ''),
                      patient.get('Gender', ''),
                      patient.get('Date Of Birth',''),
                      patient.get('SSN',''),
                      patient.get('Veteran',''),
                      isLastItem)
